﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Sales
{
    public partial class SalesOrder : System.Web.UI.Page
    {
        private Orders currentOrder;
        private static int mode;

        protected void Page_Load(object sender, EventArgs e)
        {
           WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                mode = 0;
                if (Request.QueryString["mode"] != null)
                {
                    try
                    {
                        mode = int.Parse(Request.QueryString["mode"].ToString());
                    }
                    catch { }
                }

                BindOrderList(string.Empty, DateTime.MinValue, DateTime.MinValue, mode);
            }
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindOrderList(string.Empty,DateTime.MinValue,DateTime.MinValue,0);
            Master.ExportToExcel<Entities.Orders>(grdOrders, "TotalSales");
        }

        private void BindOrderList(string searchWord, DateTime fromDate, DateTime toDate, int mode)
        {
            List<Orders> pcList = OrdersBL.GetList(Guid.Empty, Guid.Empty, searchWord, fromDate, toDate);
            if (pcList != null && pcList.Count > 0)
            {
                pcList = pcList.Where(a => a.IsActive).ToList<Orders>();
            }
            pcList = (from pl in pcList
                      orderby pl.OrderNumber descending
                      select pl).ToList<Orders>();
            switch (mode)
            {
                case 1:
                    pcList = (from pl in pcList
                              where pl.PaymentStatus.ToLower() == "pending"
                              select pl).ToList<Orders>();
                    break;
                case 2:
                    pcList = (from pl in pcList
                              where pl.OrderStatus.ToLower() != "canceled" && pl.PaymentStatus.ToLower() == "completed"
                              select pl).ToList<Orders>();
                    break;
                case 3:
                    pcList = (from pl in pcList
                              where pl.OrderStatus.ToLower() == "canceled"
                              select pl).ToList<Orders>();
                    break;
                case 4:
                    pcList = (from pl in pcList
                              where pl.OrderStatus.ToLower() == "delivered" && pl.PaymentStatus.ToLower() == "completed"
                              select pl).ToList<Orders>();
                    break;
            }

            if (chkShowPOS.Checked)
            {
                pcList = (from pl in pcList
                          where pl.OrderFrom.Trim().ToLower().Equals("pos")
                          select pl).ToList<Orders>();
            }
            else if (chkShowWeb.Checked)
            {
                pcList = (from pl in pcList
                          where pl.OrderFrom.Trim().ToLower().Equals("web")
                          select pl).ToList<Orders>();
            }

            grdOrders.DataSource = pcList;
            grdOrders.DataBind();

            if (pcList.Count == 0)
                WebUtilities.ShowMessage(this, "No Orders found");
        }

        protected void grdOrders_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdOrders.PageIndex = e.NewPageIndex;
            BindOrderList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                         (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)), mode);
        }

        protected void grdOrders_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                PlaceHolder phPaymentStatus = e.Row.FindControl("phPaymentStatus") as PlaceHolder;
                Orders myOrder = (Orders)e.Row.DataItem;

                phPaymentStatus.Visible = (myOrder.PaidAmount < myOrder.Total) ? true : false;
            }
        }

        #region Edit Order
        protected void lnkEditOrder_Click(object sender, EventArgs e)
        {
            lblEditError.Text = hdOrderID.Value = string.Empty;
            LinkButton lnkEditOrder = (LinkButton)sender;
            if (lnkEditOrder != null)
            {
                hdOrderID.Value = lnkEditOrder.CommandArgument.ToString();
                Guid ordersID = new Guid(hdOrderID.Value);
                currentOrder = OrdersBL.GetItem(ordersID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

                if (currentOrder != null)
                {
                    ddlPaymentStatus.SelectedIndex = ddlPaymentStatus.Items.IndexOf(ddlPaymentStatus.Items.FindByValue(currentOrder.PaymentStatus));
                    ddlOrderStatus.SelectedIndex = ddlOrderStatus.Items.IndexOf(ddlOrderStatus.Items.FindByValue(currentOrder.OrderStatus));

                    if (string.IsNullOrEmpty(currentOrder.InvoiceNo.Trim()) /*&& string.IsNullOrEmpty(currentOrder.DONumber.Trim())*/)
                        ddlOrderStatus.Enabled = false;

                    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "$('#divPaymentStatus').modal();", true);
                }
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (hdOrderID.Value.Trim().Length != 0)
            {
                string remarks = string.Empty;
                Guid ordersID = new Guid(hdOrderID.Value);
                currentOrder = OrdersBL.GetItem(ordersID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

                if (currentOrder != null)
                {
                    if (currentOrder.PaymentStatus.ToLower() != ddlPaymentStatus.SelectedValue.ToLower())
                    {
                        remarks += string.Format("Payment Status from {0} to {1}", currentOrder.PaymentStatus, ddlPaymentStatus.SelectedValue);
                    }

                    if (currentOrder.OrderStatus.ToLower() != ddlOrderStatus.SelectedValue.ToLower())
                    {
                        remarks += string.Format("{0}Order Status from {1} to {2}.", (string.IsNullOrEmpty(remarks) ? string.Empty : " and "), currentOrder.OrderStatus, ddlOrderStatus.SelectedValue);
                    }

                    currentOrder.Mode = GlobalConfigurations.Mode.Update;
                    currentOrder.PaymentStatus = ddlPaymentStatus.SelectedValue;
                    currentOrder.OrderStatus = ddlOrderStatus.SelectedValue;
                    currentOrder.AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                    foreach (OrdersDetails od in currentOrder.OrdersDetailsList)
                    {
                        od.Mode = GlobalConfigurations.Mode.Update;
                        od.OrderStatus = ddlOrderStatus.SelectedValue;
                    }

                    if (OrdersBL.Save(currentOrder))
                    {
                        if (remarks.Trim().Length != 0)
                            AuditTrailBL.Save(currentOrder.UniqueID, WebSession.GetUserIP(), remarks, Guid.Empty, currentOrder.AdminUserAccountID);

                        WebUtilities.ShowMessage(this, "Order details has been modified successfully");
                        BindOrderList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                     (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)), 0);
                    }
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            hdOrderID.Value = string.Empty;
        }
        #endregion

        #region Search Order
        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtFromDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtFromDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid From Date");
                return;
            }

            if (txtToDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtToDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid To Date");
                return;
            }

            BindOrderList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                         (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)), 0);
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindOrderList(string.Empty, DateTime.MinValue, DateTime.MinValue, 0);
        }
        #endregion

        #region Edit Designer Info
        protected void lnkDesignerInfo_Click(object sender, EventArgs e)
        {
            hdOrderID.Value = string.Empty;
            LinkButton lnkDesignerInfo = (LinkButton)sender;
            if (lnkDesignerInfo != null)
            {
                hdOrderID.Value = lnkDesignerInfo.CommandArgument.ToString();
                Guid ordersID = new Guid(hdOrderID.Value);
                currentOrder = OrdersBL.GetItem(ordersID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

                if (currentOrder != null)
                {
                    txtDesignerName.Text = currentOrder.DesignerName;
                    txtDesignerRemarks.Text = currentOrder.DesignerRemarks;

                    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "$('#divDesignerInfo').modal();", true);
                }
            }
        }

        protected void btnSaveDesigner_Click(object sender, EventArgs e)
        {
            if (hdOrderID.Value.Trim().Length != 0)
            {
                Guid ordersID = new Guid(hdOrderID.Value);
                currentOrder = OrdersBL.GetItem(ordersID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

                if (currentOrder != null)
                {
                    currentOrder.Mode = GlobalConfigurations.Mode.Update;
                    currentOrder.DesignerName = txtDesignerName.Text.Trim();
                    currentOrder.DesignerRemarks = txtDesignerRemarks.Text.Trim();
                    currentOrder.AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                    foreach (OrdersDetails od in currentOrder.OrdersDetailsList)
                    {
                        od.Mode = GlobalConfigurations.Mode.Update;
                    }

                    if (OrdersBL.Save(currentOrder))
                    {
                        WebUtilities.ShowMessage(this, "Designer Info has been modified successfully");
                        BindOrderList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                     (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)), 0);
                    }
                }
            }
        }

        protected void btnCancelDesigner_Click(object sender, EventArgs e)
        {
            hdOrderID.Value = string.Empty;
        }
        #endregion

        #region Order History
        protected void lnkHistroy_Click(object sender, EventArgs e)
        {
            hdOrderID.Value = string.Empty;
            LinkButton lnkHistroy = (LinkButton)sender;
            if (lnkHistroy != null)
            {
                hdOrderID.Value = lnkHistroy.CommandArgument.ToString();
                Guid referenceID = new Guid(hdOrderID.Value);

                grdHistory.DataSource = AuditTrailBL.GetList(Guid.Empty, referenceID);
                grdHistory.DataBind();

                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "$('#divHistory').modal()", true);
            }
        }

        protected void grdHistory_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Label lblName = e.Row.FindControl("lblName") as Label;
                Label lblRemarks = e.Row.FindControl("lblRemarks") as Label;

                AuditTrail aud = (AuditTrail)e.Row.DataItem;
                UserAccount adminAcc = UserAccountBL.GetItem(aud.AdminUserAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

                lblName.Text = string.Format("{0} {1}", adminAcc.FirstName, adminAcc.LastName);
                lblRemarks.Text = aud.Remarks.Replace(Environment.NewLine, "<br>");
            }
        }
        #endregion

        #region Add Payment
        protected void lnkPaymentStatus_Click(object sender, EventArgs e)
        {
            hdOrderID.Value = string.Empty;
            LinkButton lnkPaymentStatus = (LinkButton)sender;
            if (lnkPaymentStatus != null)
            {
                hdOrderID.Value = lnkPaymentStatus.CommandArgument.ToString();
                Guid ordersID = new Guid(hdOrderID.Value);
                currentOrder = OrdersBL.GetItem(ordersID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

                if (currentOrder != null)
                {
                    lblPayTotal.Text = (currentOrder.Total - currentOrder.PaidAmount).ToString("0.00");

                    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "$('#divPayment').modal();", true);
                }
            }
        }

        protected void btnSavePayment_Click(object sender, EventArgs e)
        {
            bool showPopup = false;
            if (ddlPayMethod.SelectedValue != "0")
            {
                if (ValidationUtility.ValidateDecimal(txtPaidAmount.Text.Trim()))
                {
                    decimal paid = 0;
                    decimal.TryParse(txtPaidAmount.Text.Trim(), out paid);

                    Guid ordersID = new Guid(hdOrderID.Value);
                    currentOrder = OrdersBL.GetItem(ordersID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

                    OrdersPayment ordPayment = new OrdersPayment();

                    currentOrder.PaidAmount += paid;
                    currentOrder.AdminUserAccountID = ordPayment.AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                    ordPayment.OrdersID = currentOrder.UniqueID;
                    ordPayment.PaidAmount = paid;
                    ordPayment.PaymentMethod = ddlPayMethod.SelectedValue;
                    ordPayment.PaymentType = txtBankName.Text.Trim();
                    ordPayment.TransactionReference = txtReferenceNo.Text.Trim();
                    currentOrder.PaymentStatus = ordPayment.PaymentStatus = (currentOrder.PaidAmount >= currentOrder.Total) ? "Completed" : "Pending";

                    currentOrder.PaymentMethod = string.IsNullOrEmpty(currentOrder.PaymentMethod) ? ordPayment.PaymentMethod : currentOrder.PaymentMethod;
                    currentOrder.PaymentType = string.IsNullOrEmpty(currentOrder.PaymentType) ? ordPayment.PaymentType : currentOrder.PaymentType;
                    currentOrder.TransactionReference = string.IsNullOrEmpty(currentOrder.TransactionReference) ? ordPayment.TransactionReference : currentOrder.TransactionReference;

                    currentOrder.OrdersPaymentList.Add(ordPayment);

                    if (OrdersBL.Save(currentOrder))
                    {
                        WebUtilities.ShowMessage(this, "Payment has been added successfully");

                        if (paid > 0)
                            AuditTrailBL.Save(currentOrder.UniqueID, WebSession.GetUserIP(), "Added " + ordPayment.PaymentType + " payment for " + ordPayment.PaidAmount.ToString("SGD 0.00"), Guid.Empty, currentOrder.AdminUserAccountID);

                        lblPayTotal.Text = txtPaidAmount.Text = txtBankName.Text = txtReferenceNo.Text = string.Empty;

                        BindOrderList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                     (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)), 0);
                    }
                    showPopup = false;
                }
                else
                {
                    lblPayError.Text = "Please enter valid Amount";
                    txtPaidAmount.Focus();
                    showPopup = true;
                }
            }
            else
            {
                lblPayError.Text = "Please select valid Payment Method";
                ddlPayMethod.Focus();
                showPopup = true;
            }

            if (showPopup)
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "$(#divPayment').modal();", true);
        }

        protected void btnCancelPayment_Click(object sender, EventArgs e)
        {
            hdOrderID.Value = string.Empty;
        }
        #endregion
    }
}